#TRUSTED 1ab94254d3c50457997951600597035e535db75eca7181a19b171f533391133631e5e7a0847e0009c6ec23b46c9e73d80741d3f059be2b0f891d531d677004f5b05c25219016e8a3b86740cb562eeb39d9f156048ba13cfb55e765772e7da42c2b02ce209e0484e7985838c4bd24fa426d937cbf354928583d1c5478364fd227b4f2f61a62d4a3e2058f39f032605dfbdbaaa13374e9aa0b28135262b798b10ca0bfe0deec97cea7bf15568f7be934244858e254ef2d0a9ba24e76fe2d2bd07c653ff31704c9b1983034c17bde12e7827f9b0eb06f4c450f8b21fccf0772d62bd0834f9474df08314779110f661e7c3f9fa7bf50bb7d8b65e40846082d4f664e41b9080160f13b70d7a319e1a15a01e03cd6b41a8b00e7a1d6d01c74055173c39cd0d2b182941fcc3b8cc39e1943a491fa834343c66b87f36d815db3b0bea56f95080023aa993255d99f26d5ecdb1d95724b458e9791f778001f70c8aa90edff3b80597c7ab275fe3dbc691366c6be634b8597fa2e01ff5238800d9d069f2898f633e5a5bf58c41f586c05b9b5d936be9374d3ea21a925a6540d6485b5865e611d6911c836eff2d2035779bf742f920bf930ca557e4675fb38bcea503e316874d02496903005517664d72f9c21b42f9bf5d56f8d8da9c74006a5328b448f5d4ef00aaf462b85c7cc7ba312c9576c6b1fff461568ad358213b2915771ab07f126
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15573);
 script_version ("1.4");
 script_bugtraq_id(11553);
 script_cve_id("CVE-2004-0988");
 name["english"] = "Quicktime < 6.5.2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote Mac OS X host is running a version of Quicktime which is older
than Quicktime 6.5.2.

There is an integer overflow vulnerability in the remote version of this
software which may allow an attacker to execute arbitrary code on the remote
host. To exploit this flaw, an attacker would need to send a malformed
media file to a victim on the remote host, or set up a rogue web site and
lure a user on the remote host into visiting it.

Solution : http://docs.info.apple.com/article.html?artnum=61798
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for Quicktime 6.5.2";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}

include("ssh_func.inc");
include("macosx_func.inc");

cmd = GetBundleVersionCmd(file:"QuickTimeMPEG.component", path:"/System/Library/Quicktime");

if ( islocalhost() )
 buf = pread(cmd:"bash", argv:make_list("bash", "-c", cmd));
else
{
 soc = ssh_login_or_reuse_connection();
 if ( ! soc ) exit(0);
 buf = ssh_cmd(socket:soc, cmd:cmd);
 ssh_close_connection();
}

if ( buf !~ "^[0-9]" ) exit(0);

buf = chomp(buf);

set_kb_item(name:"MacOSX/QuickTime/Version", value:buf);

version = split(buf, sep:'.', keep:FALSE);

if ( int(version[0]) < 6 ||
    ( int(version[0]) == 6 && int(version[1]) < 5 ) ||
    ( int(version[0]) == 6 && int(version[1]) == 5 && int(version[2]) < 2 ) ) security_hole ( 0 );
