#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25346);
 script_version ("$Revision: 1.4 $");

 script_cve_id("CVE-2007-2388", "CVE-2007-2389");
 script_bugtraq_id(24221, 24222);
 script_xref(name:"OSVDB", value:"35575");
 script_xref(name:"OSVDB", value:"35576");

 name["english"] = "Quicktime 7.1.6 Security Update (Mac OS X)";
 
 script_name(english:name["english"]);
 
  desc = "
Synopsis :

The remote Mac OS X host contains an application that is prone to
multiple attacks. 

Description :

According to its version, the installation of Quicktime on the remote
Mac OS X host which contains a bug which might allow a rogue Java 
program to write anywhere in the heap.

An attacker may be able to leverage these issues to execute arbitrary 
code on the remote host by luring a victim into visiting a rogue page
containing a malicious Java applet.

See also : 

http://docs.info.apple.com/article.html?artnum=305531

Solution :

Install the Quicktime 7.1.6 Security Update. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";



 script_description(english:desc);
 
 summary["english"] = "Check for Quicktime 7.1.6 Security Update";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("macosx_Quicktime652.nasl");
 script_require_keys("MacOSX/QuickTime/Version");
 exit(0);
}

ver = get_kb_item("MacOSX/QuickTime/Version");
if (! ver ) exit(0);

packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);



version = split(ver, sep:'.', keep:FALSE);
if ( (int(version[0]) == 7 && int(version[1]) == 1 && int(version[2]) == 6) )
{
 if ( ! egrep(pattern:"^SecUpdQuickTime716\.pkg", string:packages) )
	security_hole(0);
}
