#TRUSTED 588fc3b085ebeb3956626b47479980185981a7ad49e9e025a0277de8a7712a570d20e9f356d08c1130a3fd4599197de75d1c6454f1e9f7492475cf50cf1dbcf787dd756de391bd986e73229a62925b73e1ad226296254cb212cd5c7db4acbb4f5b4a9bcb8053bf24c06a2e90c316d5747ab9ec31c470edfa51fe359001549494574a32690e94e4802dd76d8f806a681f60dd5ab00b6d3d4130f689a443d629efcb19a42bad7c022540278240436677bca080b7e0742fe25e372839cb4f59eaaa1daf9c4389ccda334d29a3ce9007538ad4d6966084b8611ca49948b675502f87347853df3b3787895cbb77da0dfd66b3b85fd820580a4594b4e42cf047256a348559493024d2cf03f8762dd134a17f053c8931e3af95ad6a1787a44bfcb856f87940f6a057fa34ff60c4e9f938cd0ddfe852788e5809a404318a1dfe8e767669b07849b60ae180393f009a147d71f42e2e678a58fa0e3429202811545791ee5aaa178c3b42ab0acb954813af92fc376a887a6f8f2203560ff370f56d62d4fa7b0a11508ab1bee77ebdc44abe428370091c872e96c559bb968763589211c5679b2324afe2efb9dc2053c8dfafae979659b9bd8f0ce66f6d5ce4c292bd9ca13c53effefbc1018dce2ff672d40bc587830f38b9a121aa0c6aab2a90309cf73fd03c4a3cc820aa7906dca5b8bb75ed29223f0918ade39ca7a5c19c481001bbc89588
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23926);
 script_version ("1.2");
 script_bugtraq_id(21672);
 script_cve_id("CVE-2006-5681");
 name["english"] = "Mac OS X Security Update 2006-008";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host is missing a Mac OS X update which fixes a security
issue.

Description :

The remote host is running a version of Mac OS X 10.4 which does not have
the security update 2006-008 applied.

This update fixes a flaw in QuickTime which may allow a rogue website to 
obtain the images rendered on the user screen. By combining this flaw
with Quartz Composer, an attacker may be able to obtain screen shots
of the remote host.

Solution : 

Install the security update 2006-008 :

http://www.apple.com/support/downloads/securityupdate2006008universal.html
http://www.apple.com/support/downloads/securityupdate2006008ppc.html


See also : 

http://docs.info.apple.com/article.html?artnum=304916

Risk factor :

Low / CVSS Base Score : 2.6
(CVSS2#AV:N/AC:H/Au:N/C:P/I:N/A:N)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the presence of the SecUpdate 2006-008";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}

include("ssh_func.inc");
include("macosx_func.inc");

# Look at the exact version of QuartzComposer
cmd = GetBundleVersionCmd(file:"QuartzComposer.component", path:"/System/Library/Quicktime", long:TRUE);

if ( islocalhost() )
 buf = pread(cmd:"bash", argv:make_list("bash", "-c", cmd));
else
{
 soc = ssh_login_or_reuse_connection();
 if ( ! soc ) exit(0);
 buf = ssh_cmd(socket:soc, cmd:cmd);
 ssh_close_connection();
}

if ( buf !~ "^[0-9]" ) exit(0);

buf = chomp(buf);

set_kb_item(name:"MacOSX/QuickTimeQuartzComposer/Version", value:buf);

version = split(buf, sep:'.', keep:FALSE);

if (( int(version[0]) == 22 && int(version[1]) < 1 ) ||
    ( int(version[0]) == 22 && int(version[1]) == 1 && int(version[2]) < 3 ) ) security_note( 0 );
