#TRUSTED 02818a47b9ec23e8c7a56328b809e2352f02be47eb3623e49fe99e99f0023538f28e4629c990aaaba57a5cb0e23c594770646e9eabb50e5259f53627ad353b0c8d3632c8e8e79fd25045de635ed3f2558e072251b369e8c816493c84b9b356976c3721e0f0140a0250d032adb451958d4835d12ba35304001468c3049aaa7fa0698274a07b795d8f7db880ee8f1ac351a09f878b37da801c65abb941fef9fd28794a2ff0aa0d539ee2fc1d6f853f1d7ca9411c7365561913be2ca351ff02700b8775948d9a62e9aa8a37fcdb4cb321723525d547470b284f453d66ddda1c5f8730d39332719b5ab01940bd193b60c8199faa04f6d37e84d94be2250ac0affa7ad16a3c8b88584327391cb80a7ae7a1f4e09177c8bc7555f3dcae9918c27a9080bf60e2f6699bd6ca7da4a444ef24984660152e2d0324e371410672842fe766a619d4e1d37123efd917f85deb3d79c02615a3a2885d9939b15ae29ad641074eb433fa82a65d6410b7470d89002b328d22c49333d131bf61a97d8aefa5c1b094ac6862c98cc97a714ea193f0003e8395466a79d4b913b50119843aa35955bf9528689a9a3ef762420b657aeecdf284902d8ed9fb719ef89cc002778401c0730955ea74964396f1a7c0b3c4d6ea3933c428e7e227047962006f87602c8aba78b1cdc4cde476665ff18faaea3125ea4182bc914ead5962d2ca6661addea1ecf97454
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24234);
 script_version ("1.7");

 script_cve_id("CVE-2007-0015");
 script_bugtraq_id(21829);
 script_xref(name:"OSVDB", value:"31023");

 name["english"] = "Mac OS X Security Update 2007-001";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host is missing a Mac OS X update which fixes a security
issue.

Description :

The remote host is running a version of Mac OS X 10.3 or 10.4 which does 
not have the security update 2007-001 applied.

This update fixes a flaw in QuickTime which may allow a rogue website to 
execute arbitrary code on the remote host by exploiting an overflow in
the RTSP URL handler.

Solution : 

Install the security update 2007-001 :

http://www.apple.com/support/downloads/securityupdate2007001universal.html
http://www.apple.com/support/downloads/securityupdate2007001panther.html

See also : 

http://docs.info.apple.com/article.html?artnum=304989

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the presence of the SecUpdate 2007-001";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}

include("ssh_func.inc");
include("macosx_func.inc");

function exec(cmd)
{
 local_var soc, buf;

 if ( islocalhost() )
  buf = pread(cmd:"bash", argv:make_list("bash", "-c", cmd));
 else
 {
  soc = ssh_login_or_reuse_connection();
  if ( ! soc ) exit(0);
  buf = ssh_cmd(socket:soc, cmd:cmd);
  ssh_close_connection();
 }

 if ( buf !~ "^[0-9]" ) exit(0);

 buf = chomp(buf);
 return buf;
}

# Look at the exact version of QuickTimeStreaming
cmd = GetBundleVersionCmd(file:"QuickTimeStreaming.component", path:"/System/Library/Quicktime");
buf = exec(cmd:cmd);
set_kb_item(name:"MacOSX/QuickTimeSteaming/Version", value:buf);

version = split(buf, sep:'.', keep:FALSE);

if (( int(version[0]) == 7 && int(version[1]) < 1 ) ||
    ( int(version[0]) == 7 && int(version[1]) == 1 && int(version[2]) < 3 ) ) {
	 security_warning( 0 );
	exit(0);
}
else if ( int(version[0]) == 7 && int(version[1]) == 1 && int(version[2]) == 3 ) 
{
 cmd = _GetBundleVersionCmd(file:"QuickTimeStreaming.component", path:"/System/Library/Quicktime", label:"SourceVersion");
 buf = exec(cmd:cmd);
 if ( int(buf) < 4650200 ) security_warning(0);
}
 
