#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24354);
 script_version ("$Revision: 1.4 $");

 script_cve_id(
  "CVE-2007-0197",
  "CVE-2007-0614",
  "CVE-2007-0710",
  "CVE-2007-0021",
  "CVE-2007-0023"
 );
 script_bugtraq_id(21980, 22146, 22188, 22304);
 script_xref(name:"OSVDB", value:"32695");
 script_xref(name:"OSVDB", value:"32713");
 script_xref(name:"OSVDB", value:"32714");
 script_xref(name:"OSVDB", value:"32715");

 name["english"] = "Mac OS X Security Update 2007-002";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host is missing a Mac OS X update which fixes a security
issue. 

Description :

The remote host is running a version of Mac OS X 10.4 which does not
have the security update 2007-002 applied. 

This update fixes security flaws in the following applications :

- Finder
- iChat
- UserNotification

Solution : 

Install the security update 2007-002 :

http://www.apple.com/support/downloads/securityupdate2007002universal.html
http://www.apple.com/support/downloads/securityupdate2007002panther.html

See also : 

http://docs.info.apple.com/article.html?artnum=305102

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the presence of the SecUpdate 2007-002";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);



uname = get_kb_item("Host/uname");
if ( egrep(pattern:"Darwin.* (7\.[0-9]\.|8\.[0-8]\.)", string:uname) )
{
  if (!egrep(pattern:"^SecUpd(Srvr)?2007-002", string:packages)) security_hole(0);
}
