#
# (C) Tenable Network Security, Inc.
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25830);
 script_version ("$Revision: 1.2 $");
 if ( NASL_LEVEL >= 3000 )
 {
  script_cve_id(
   "CVE-2004-0996",
   "CVE-2004-2541",
   "CVE-2005-0758",
   "CVE-2005-2090",
   "CVE-2005-3128",
   "CVE-2006-2842",
   "CVE-2006-3174",
   "CVE-2006-4019",
   "CVE-2006-6142",
   "CVE-2007-0450",
   "CVE-2007-0478",
   "CVE-2007-1001",
   "CVE-2007-1262",
   "CVE-2007-1287",
   "CVE-2007-1358",
   "CVE-2007-1460",
   "CVE-2007-1461",
   "CVE-2007-1484",
   "CVE-2007-1521",
   "CVE-2007-1583",
   "CVE-2007-1711",
   "CVE-2007-1717",
   "CVE-2007-1860",
   "CVE-2007-2403",
   "CVE-2007-2404",
   "CVE-2007-2405",
   "CVE-2007-2406",
   "CVE-2007-2407",
   "CVE-2007-2408",
   "CVE-2007-2409",
   "CVE-2007-2410",
   "CVE-2007-2442",
   "CVE-2007-2443",
   "CVE-2007-2446",
   "CVE-2007-2447",
   "CVE-2007-2589",
   "CVE-2007-2798",
   "CVE-2007-3742",
   "CVE-2007-3744",
   "CVE-2007-3745",
   "CVE-2007-3746",
   "CVE-2007-3747",
   "CVE-2007-3748",
   "CVE-2007-3944"
  );
  script_bugtraq_id(
   11697, 
   13582,
   23910,
   23972,
   23973,
   24195,
   24196,
   24197,
   24198,
   24653,
   25159
  );
 }
 name["english"] = "Mac OS X Security Update 2007-007";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host is missing a Mac OS X update which fixes various
security issues. 

Description :

The remote host is running a version of Mac OS X 10.4 or 10.3 which
does not have the security update 2007-007 applied. 

This update contains several security fixes for the following programs :

 - bzip2
 - CFNetwork
 - CoreAudio
 - cscope
 - gnuzip
 - iChat
 - Kerberos
 - mDNSResponder
 - PDFKit
 - PHP
 - Quartz Composer
 - Samba
 - SquirrelMail
 - Tomcat
 - WebCore
 - WebKit

Solution : 

Install the security update 2007-007 :

http://www.apple.com/support/downloads/securityupdate200700710410universal.html
http://www.apple.com/support/downloads/securityupdate20070071039.html
http://www.apple.com/support/downloads/securityupdate20070071039server.html

See also : 

http://docs.info.apple.com/article.html?artnum=306172

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the presence of the SecUpdate 2007-007";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);



uname = get_kb_item("Host/uname");
if ( egrep(pattern:"Darwin.* (7\.[0-9]\.|8\.[0-9]\.|8\.10\.)", string:uname) )
{
  if (!egrep(pattern:"^SecUpd(Srvr)?2007-007", string:packages)) security_hole(0);
}
