#TRUSTED 1c69191ba04dec127d55dfebeaaf4b876b2e08454694f5d3ffccba0b9bc7be214322d4d5092e1457a456bde946a15d286739ae73826176b2effdf0073a5ccc3497f8cdbba544b43e24d9b19331e2b2c4c3bc5901ecd0177f72c0ba83118c6ff969b5ff4caa6516b63b8501268d07540d37b49ec16aae77a12fdf0dbb161943412ba9c24b55e5fae16b3ac16f6dd78bfaaee1c40acc0584e4503ecb67dbec622b9d04fed0c12a9c5e0fa63b681b86768d2b4f1a39becf0b084187ed39992d900a7db05c85efdc32b250536c1e732586c91ec59a52ff3b816e40dad0c578667353f2dd8817155add5928a5d9b43dc1fce00f2e782c932486eb0d1c6caa9574731bc4e44c5bf8894928e39ed17205863274f3d4cb60b6afb95194b2453c07580a2d3a3b34b5c1df5d902aec3a085437615b0697ae1ff983a7cbe33c55cbce878b72e3c9bd66d69721e8cef73815eb3b51dbc349f61c8dece6b65487a3a1536605449f6c532a7c15091f12b8e183fd0ece401997c7178d13e429bc3a1ad1e89641ec14f64bfc2972ac270c91766023c47549b92753dfe697714e774898e534b89c8f37487171440bcc3ae6034d05e255d6f2c22fb1784b24d1987cb983cc4970f63cc79969772c0dc390491a28b06757935ce41ff3220a224b30b387e5499aba03f8d44f4257740b6b34da0ac2930d5abcb0f597b64888708f9fdad6c0d793ddfb1b
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(16151);
 script_version ("1.1");
 script_bugtraq_id(12238);
 script_cve_id("CVE-2005-0043");
 name["english"] = "iTunes < 4.7.1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of iTunes which is older than
version 4.7.1.

The remote version of this software is vulnerable to a buffer overflow
when it parses a malformed playlist file (.m3u or .pls files).

Solution : Upgrade to iTunes 4.7.1
See also : http://docs.info.apple.com/article.html?artnum=61798
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check the version of iTunes";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}

include("ssh_func.inc");
include("macosx_func.inc");

packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);

cmd = GetBundleVersionCmd(file:"iTunes.app", path:"/Applications");

if ( islocalhost() )
 buf = pread(cmd:"bash", argv:make_list("bash", "-c", cmd));
else 
{
 sock = ssh_login_or_reuse_connection();
 if ( ! sock ) exit(0);
 buf = ssh_cmd(socket:sock, cmd:cmd);
 ssh_close_connection();
}

if ( ! buf ) exit(0);
if ( ! ereg(pattern:"^iTunes [0-9.]", string:buf) ) exit(0);
version = ereg_replace(pattern:"^iTunes ([0-9.]+),.*", string:buf, replace:"\1");
set_kb_item(name:"iTunes/Version", value:version);
if ( egrep(pattern:"iTunes 4\.([0-6]\..*|7|7\.0)$", string:buf) ) security_hole(0); 
