#TRUSTED 745a2b58919f30a527f573baa8024aecdfa643b4b36378b96df516fdf9b68bf07b5bb337e2cedf649793786f168ec53fc77cd8b13ab59b87bd50e4725665cf6f1ea5fc6ac79ce250a8b60e2510f087b94d1337355e997774f484e76b9ff3b6a5a2995bf152988b193368545a0d0c3ef1f5edce9b96791299ce5770dd47ed0ff44c07011790ab83e006bd4dafd6290eb4faf4a74bec1f1244288e7796dfe432e99bb01911f497e2572625ef64d02b03914bf97825b3dfc890c6570f48335e72d955c551f953fdb39bd4c1ba983d563b5a30684d73c08a7c8a6008de44d95c510e0967521923ea4454be9f82d6080719a697ac942aeb90642f0ab696ecefd32d50a0b5758dec7b6285934644dd061904d65fbb842a47d4e67a7e1896203c3b01c7c4db5ec0d5ac381c781496ed7ab74b71fbcc123d08d470b23045b24b4bac22540e2ea81e772fdd0923092882a00656d66d8379531424710372178b8424d59baa49bc65076777f53805085a8cc83f118c6bca8fd7fcddd0fc76c84374b65c64d66775725a67d175c38b203a72335dac170faadce8fb9ec843d9d9650d021a94b0190f7ea22fe74c5c7cd29e94f4af473cef166002c85e036232b1f2291de4ef183a13167bb675d8f1fdb2b7a2230fc71045ccbf30658bdf71587a80ea3ed6937323ec462882585865cc6081f48702ff70dbdade82bd38832d859b5619b49d479d
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15786);
 script_version ("1.2");
 script_bugtraq_id ( 11728 );
 name["english"] = "iCal 1.5.4";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of iCal which is older than version 1.5.4.

iCal 1.5.4 contains security enhancements to protect the remote computer
when importing events with alarms which open files or application.


Solution : http://www.apple.com/ical/download/
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for iCal 1.5.4";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


include("ssh_func.inc");
include("macosx_func.inc");
packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);


cmd = GetBundleVersionCmd(file:"iCal.app", path:"/Applications");
uname = get_kb_item("Host/uname");
if ( egrep(pattern:"Darwin.*", string:uname) )
{
  if ( islocalhost() )
   buf = pread(cmd:"bash", argv:make_list("bash", "-c", cmd));
  else 
  {
   soc = ssh_login_or_reuse_connection();
   if ( ! soc ) exit(0);
   buf = ssh_cmd(socket:soc, cmd:cmd);
   ssh_close_connection();
  }
 if ( buf && ereg(pattern:"^(1\.[0-4]\.|1\.5\.[0-3]([^0-9]|$))", string:buf) ) security_hole (0);
}
