#TRUSTED 2b98971b94356b56c93e5e91f7ca440fb8a27a0eac0be765add857b4e7d8ac6b51cd604ac9d32a3d813b120ec1d352abc2e5f7f6db19fe4108f4606f6e8dccfb198bfc4fa056041e8d158489a87ada6e2def8c2cd8a6cab362b4297dd593bc4aa75a13318603d8b4efa0095a062f9708ec6a6eb5770a6db2b0aef62df51dc7a2098782815c70858987a5ffa7fdb74187ff9949845e970fb81bc5c212c879dbeda9036b8de4ae618a4687ff3c05f79ada5c128dcc249d278e240ec862a6578f295da73f54b34643a7b83ec423dc940edb28bcfea50503785c93b1269f0480cff775453984fe4a3de47d84a79ece4b707efc74154cb8e6c4bf0fae2ff0af08941c6c7250a20979a2ff27d9e9170be27949d7b943259f468594242cdfd01b1608fc7409927b57fa1c9fb4c2ed200259dcf19e4a65f0b9d28aae8dac14fd824658f183d87d9b878be6e03eb17f0ed157946b44c80af20211f40bebe4774b8c865121cb10a7f0894b8107935b4777367e78df235cf9e78b9ec7985def0c275a0922e420bc7f5a809ddbf976c801a36a69b0fd3eb24eab1f8af42d7464ada4c40704ed44e6b196ef1f2c3963988cbb1315de3f6e2bf65cdc4af4b5db4f4193fd817f3617dfc7bab6c11de7470d203dca817c42c2e95cbc3c4bea5c0302636392cdac189ea379d18baff283e5358590798eb64e13eca580040b6d5af6f4d6defe5ac26a
#
# (C) Tenable Network Security, Inc.
#
#


if (!defined_func("bn_random")) exit(0);


if (description)
{
  script_id(30201);
  script_version ("1.1");

  script_cve_id("CVE-2008-0043");
  script_bugtraq_id(27636);

  script_name(english:"iPhoto < 7.1.2 Format String Vulnerability");
  script_summary(english:"Checks version of iPhoto");

  desc = "
Synopsis :

The remote Mac OS X host contains an application that is affected by a
format string vulnerability. 

Description :

The remote host is running a version of iPhoto 7.1 older than version
7.1.2.  Such versions are reportedly affected by a format string
vulnerability.  If an attacker can trick a user on the affected host
into subscribing to a specially-crafted photocast, he may be able to
leverage these issues to execute arbitrary code on the affected host
subject to the user's privileges. 

See also :

http://docs.info.apple.com/article.html?artnum=307398
http://lists.apple.com/archives/security-announce/2008/Feb/msg00000.html
http://www.apple.com/support/downloads/iphoto712.html

Solution :

Upgrade to iPhoto 7.1.2 or later. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"MacOS X Local Security Checks");
 
  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");
 
  script_dependencies("ssh_get_info.nasl");
  script_require_keys("Host/MacOSX/packages");

  exit(0);
}



include("macosx_func.inc");
include("ssh_func.inc");


uname = get_kb_item("Host/uname");
if (!uname) exit(0);

if (egrep(pattern:"Darwin.*", string:uname))
{
  cmd = GetBundleVersionCmd(file:"iPhoto.app", path:"/Applications");
  if (islocalhost())
    version = pread(cmd:"bash", argv:make_list("bash", "-c", cmd));
  else 
  {
    soc = ssh_login_or_reuse_connection();
    if (!soc) exit(0);

    version = ssh_cmd(socket:soc, cmd:cmd);
    ssh_close_connection();
  }

  if (version)
  {
    version = chomp(version);
    ver = split(version, sep:'.', keep:FALSE);
    for (i=0; i<max_index(ver); i++)
      ver[i] = int(ver[i]);

    if (
      ver[0] == 7 && 
      (
        ver[1] == 0 ||
        (ver[1] == 1 && ver[2] < 2)
      )
    )
    {
        report = string(
          "\n",
          "The remote version of iPhoto is ", version, ".\n"
        );
        security_warning(port:0, extra:report);
    }
  }  
}
