#
#  (C) Tenable Network Security
#


if (description)
{
  script_id(25999);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-3752");
  script_bugtraq_id(25567);
  script_xref(name:"OSVDB", value:"38528");

  script_name(english:"iTunes < 7.4 Malformed Music File Heap Overflow (Mac OS X)");
  script_summary(english:"Check the version of iTunes"); 
 
 desc = "
Synopsis :

The remote Mac OS X host contains an application that is affected by a
remote code execution flaw. 

Description :

The remote host is running iTunes, a popular jukebox program. 

The remote version of iTunes is vulnerable to a heap overflow when
it parses a specially crafted MP4/AAC file.  By tricking a user into
opening such a file, a remote attacker may be able to leverage this
issue to execute arbitrary code on the affected host, subject to the
privileges of the user running the application. 

See also :

http://docs.info.apple.com/article.html?artnum=306404

Solution :

Upgrade to iTunes 7.4 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"MacOS X Local Security Checks");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("macosx_itunes_detect.nasl");
  script_require_keys("MacOSX/iTunes/Version");

  exit(0);
}


vers = get_kb_item("SMB/iTunes/Version");
if ( isnull(vers) ) exit(0);
vers = split(vers, sep:'.', keep:FALSE);
if ( int(vers[0]) > 0 && (
     int(vers[0]) < 7 ||
     (int(vers[0]) == 7 && int(vers[1]) < 4 ) ) )
	security_hole(port);
