#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(19702);
 script_cve_id("CVE-2005-2527", "CVE-2005-2530", "CVE-2005-2738");
 script_bugtraq_id(14825, 14826, 14827);
 name["english"] = "Mac OS X : Java 1.3.1 and 1.4.2 Release 2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host is affected by multiple vulnerabilities. 

Description :

The remote host is missing a security bugfix for Java 1.4.2 and 1.3.1. 

This update fixes several security vulnerabilities which may allow a
java applet to escalate its privileges. 

To exploit these flaws, an attacker would need to lure an attacker
into executing a rogue Java applet. 

See also :

http://docs.info.apple.com/article.html?artnum=302266

Solution : 

Upgrade to Java 1.3.1 / 1.4.2 Release 2.

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Check for Java 1.4.2";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);

uname = get_kb_item("Host/uname");
# Mac OS X 10.3.9 and 10.4.2 only
if ( egrep(pattern:"Darwin.* 7\.[0-9]\.", string:uname) )
{
  if ( !egrep(pattern:"^JavaSecurityUpdate4\.pkg", string:packages) ) security_hole(0);
}
else if ( egrep(pattern:"Darwin.* 8\.[0-2]\.", string:uname) )
{
  if ( !egrep(pattern:"^Java131and142Release2\.pkg", string:packages) ) security_hole(0);
}
