#TRUSTED 9e65b22551fb43d5dd12316eff35c0dff173c09dde1a1d0a8086880b10d5041f0f7654c42f5878b34fffa42702b6b16769058843d6f38ef0c382563a3272b47d6be3877484fde9be1cc8c72563bb27d984399fb5f0fa459d6d02cd5d98929edc0fb43946043a87ab61214eb97243e3e3c963ad7852a92e8b8bc57fdcf85148b4430b6c6ee2ca2e07a29fe79e79dff4e2d37b0d4db415227cea49fe2bed8b344d02dc4d5a3b2975461680acf7af53b94c0fa30a20a372b14eac9dc0c3b24e48821594c34e35da33faa81b82d9d2d64bdf9b35dcaadfafbf5dc11d6e9aa3ba19d5ec633aca2e59f66c7f66ecb48527743ea21b22c3ce5af2af398fb02add24fcde32012ec51735a25bd3c9197cbe6a59f5a47589523806ca80e1eeddfc9ac6aa75efc523ceea32713580c1312d36b6ed67474d14eb1ea575ad64ade1bc1a0bda9aae593cbffa9d44db35b6124cd9035c65892e77757c1b1d442104005bce17e0557d2e1526517fe705e1160de8b0cf8d2e2d48bf9b27c73b795ccfca4f519c7c36e6c63351501efa39047b24896629c22a2dbe694894948ba4198911350ab4db46eb539f8e5b39633e8882f7ab560c3f1bb878e22118a7278146cc6cde115d01e2e2dd729f9b4e6671d1deea2d4fab5eed082f47805217a881707a4ca45c198f188db6b49a67f285171ab524cab76b96858c24be34b1a8116bc4e0c66b6dc9eba1
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29702);
 if ( NASL_LEVEL >= 3000 )
  script_cve_id("CVE-2007-5862", "CVE-2006-4339", "CVE-2006-6731", "CVE-2006-6736", "CVE-2006-6745", "CVE-2007-0243", "CVE-2007-2435", "CVE-2007-3504", "CVE-2007-3698", "CVE-2007-3922", "CVE-2007-4381", "CVE-2007-5232", "CVE-2006-4339", "CVE-2006-6731", "CVE-2006-6745", "CVE-2007-0243", "CVE-2007-2435", "CVE-2007-2788", "CVE-2007-2789", "CVE-2007-3503", "CVE-2007-3504", "CVE-2007-3655", "CVE-2007-3698", "CVE-2007-3922", "CVE-2007-4381", "CVE-2007-5232");
 script_bugtraq_id(26877);
 script_version("1.0");
 name["english"] = "Mac OS X : Java for Mac OS X 10.4 Release 6";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host is affected by multiple vulnerabilities. 

Description :

The remote Mac OS X 10.4 host is running a version of Java for Mac OS X which
is older than release 6.

The remote version of this software contains several security vulnerabilities 
which may allow a rogue java applet to escalate its privileges and to add or
remove arbitrary items from the user's KeyChain.

To exploit these flaws, an attacker would need to lure an attacker
into executing a rogue Java applet. 

See also :

http://docs.info.apple.com/article.html?artnum=307177

Solution : 

Upgrade to Java for Mac OS X 10.4 release 6

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Check for Java Release 6";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


include("ssh_func.inc");
include("macosx_func.inc");

function exec(cmd)
{
 local_var soc, buf;

 if ( islocalhost() )
  buf = pread(cmd:"bash", argv:make_list("bash", "-c", cmd));
 else
 {
  soc = ssh_login_or_reuse_connection();
  if ( ! soc ) exit(0);
  buf = ssh_cmd(socket:soc, cmd:cmd);
  ssh_close_connection();
 }

 if ( buf !~ "^[0-9]" ) exit(0);

 buf = chomp(buf);
 return buf;
}


packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);

uname = get_kb_item("Host/uname");
# Mac OS X 10.4.10, 10.4.11 only
if ( egrep(pattern:"Darwin.* 8\.(10|11)\.", string:uname) )
{
 cmd = _GetBundleVersionCmd(file:"JavaPluginCocoa.bundle", path:"/Library/Internet Plug-Ins", label:"CFBundleVersion");
 buf = exec(cmd:cmd);
 if ( ! strlen(buf) ) exit(0);
 array = split(buf, sep:'.', keep:FALSE);
 if ( int(array[0]) < 11 ||
     (int(array[0]) == 11 && int(array[1]) <= 7 ) )
 {
  cmd = _GetBundleVersionCmd(file:"JavaPluginCocoa.bundle", path:"/Library/Internet Plug-Ins", label:"SourceVersion");
  buf = exec(cmd:cmd);
  if ( strlen(buf) && int(buf) < 1120000 ) security_warning(0);
 }
}
