#TRUSTED 0d2e0831bf9bfc4680ae89b35a243d32804ca62673fb9606b90fe282fb90f8978a5ddbfc7d1e7ed7c799c9ce0c75daa9ced3bc373e419bba56b5d999cbb0699ec59ef9749edf18c57d7840cde3a19b81f66ef7c2ea20195fe4679755402539a8cab286f5f04a991e660764f1da8629f23bc0556fab06f6bbacb30a529c7c4d8a38b39fbd20182da6936581e94897846d4b21f6e419a57dfcab887da3b077a6500d027fb4a521af1cdf7ea8f9c0407e5899bc1e816ebf39e1b5c199033dd96e14a21063e5abf88626469321a6e5ca1f6a77cd3c8d46dccc986525201b82b265a33b930eb7a43cd8706d55bce23295fc5b92061c83b7401659e241c77a14f03fee92cc390a8ec25be187efda00c085db7c8c21d849ba1d54d479cce4a2890477dd233d1d6a28f39564dad8bec750da38c988bdf8983620d34c29e735ca5cdecbfbdf9fb58fb0587063ad2e53eb3f25e8ababfe7cc1e8e7aaeebde5f8837da9712cc2f0683adba755eab29ac440e64be413821578a89b82a693fb9b1ff7f32dbb012e4cbcc513aeeb08bccf1954db5989418d501153c25952934fcbc739cfa75c928f77d4bde97c51aac429e12fb80b85f6fcc591499cbb4fa684b38803865eb473041c5e98c48e00ca6c1b66e29d241a7183fc6edcd89d02470efa4cbefe5f9958d8b0d3235ee4c4c461f4c72c098b7745f74612bef213b460a3a5acefed1f6598
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(22025);
 script_bugtraq_id(18938, 18915, 18913, 18912, 18911, 18890, 18888, 18886, 18885);
 script_version ("1.0");
 script_cve_id("CVE-2006-1301", "CVE-2006-1302", "CVE-2006-1304", "CVE-2006-1306", "CVE-2006-1308", "CVE-2006-1309", "CVE-2006-2388", "CVE-2006-3059", "CVE-2006-1316", "CVE-2006-2389");
 
 name["english"] = "Vulnerabilities in Microsoft Excel and Office Could Allow Remote Code Execution (917284/917285) (Mac OS X)";
 

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through Microsoft
Excel.

Description :

The remote host is running a version of Microsoft Office
which is subject to various flaws which may allow arbitrary code to be run.

An attacker may use this to execute arbitrary code on this host.

To succeed, the attacker would have to send a rogue file to 
a user of the remote computer and have it open it with
Microsoft Excel or another Office application.

Solution : 

Microsoft has released a set of patches for Office for Mac OS X :

http://www.microsoft.com/technet/security/bulletin/ms06-037.mspx
http://www.microsoft.com/technet/security/bulletin/ms06-038.mspx

Risk factor : 

Medium / CVSS Base Score : 5.1
(CVSS2#AV:N/AC:H/Au:N/C:P/I:P/A:P)";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for Excel 2004 and X";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


include("ssh_func.inc");
include("macosx_func.inc");


uname = get_kb_item("Host/uname");
if ( egrep(pattern:"Darwin.*", string:uname) )
{
  off2004 = GetCarbonVersionCmd(file:"Microsoft Excel", path:"/Applications/Microsoft Office 2004");
  offX    = GetCarbonVersionCmd(file:"Microsoft Excel", path:"/Applications/Microsoft Office X");
  if ( ! islocalhost() )
  {
   soc = ssh_login_or_reuse_connection();
   if ( ! soc ) exit(0);
   buf = ssh_cmd(socket:soc, cmd:off2004);
   if ( buf !~ "^11" )
    buf = ssh_cmd(socket:soc, cmd:offX);
   ssh_close_connection();
  }
  else
  {
  buf = pread(cmd:"bash", argv:make_list("bash", "-c", off2004));
  if ( buf !~ "^11" )
    buf = pread(cmd:"bash", argv:make_list("bash", "-c", offX));
  }


 if ( buf =~ "^(10\.|11\.)" )
	{
	  vers = split(buf, sep:'.', keep:FALSE);
	  # < 10.1.7
	  if ( int(vers[0]) == 10 && ( int(vers[1]) < 1  || ( int(vers[1]) == 1 && int(vers[2]) < 7 ) ) ) security_warning(0);
	  else
          # < 11.2.5
	  if ( int(vers[0]) == 11 && ( int(vers[1]) < 2  || ( int(vers[1]) == 2 && int(vers[2]) < 5 ) ) ) security_warning(0);
	} 
}
