#TRUSTED 9f17071d16ec464d5260cc3415cf0fd34b78cbfbaf41c7d58b9ad68d6547502d94a2ceabaaaa970038149332c0ffe2b89beec2d0f471590e29189c1ae4b73b58059dea1a09d1d5e21fc3866298ab655d31c9698dd7cbe49171b65362526f8f36e9c80eb9c1e03429099dacdd2262918cc50bf54b067cab8324ddc0e8bfa2f9607f0b73dfb3e806bf01d515092064980483b7ac03e249fc5315cc03bc46445fda91ebff1c4b096b2c7c034be5bcfe39e312254fca9aac5101adf46d0566517afb2d1c0f880fa731e53138bed04640c3f577d9280b31b4dbdf0e770a207e53223603630c2faa150e1a183d32d0f3f5fd9d2d9fc559ee0c61a065f8875510f39e2827e8f8556dffe638be89bbbbcc94e82b089eb0e5e3a1d78d2be75ba4e78017c63c5554373a4aa71d886e56ed0b7154f3a0f57203e07ce385b9d1c660ccc51cd235e1d17cd275750c149ac0ad56f727a9a4d8f1f518573c6e12e043085f2b2562c508325d6dd06c86c507aa4c4adf6d6d54a9341803ce85cab8d57455f6e3d24b5d19e46f6dfae18a1718909ffdedf054364bedb8b62625a4355c0bd2da4aafdfb0b0cc50b2ae42e116e9a1c6bbb2db446fb16220866a0c746b013dc4f313a01ed7cbc7cd583f309150e112a4b1e6c692e576e4869fe34c92ea8ac59c8b96a4f125994304e973623878fa3aa9bcf6b90a6c74e0e4fd2331644c205e3de0ea4430
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24328);
 script_version ("1.0");
 script_cve_id("CVE-2006-3877", "CVE-2007-0671", "CVE-2006-5994", "CVE-2006-6456", "CVE-2006-6561", "CVE-2007-0208", "CVE-2007-0209", "CVE-2007-0515");
 
 name["english"] = "Vulnerabilities in Microsoft Word and Office Could Allow Remote Code Execution (929434/932554) (Mac OS X)";
 

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through Microsoft Office

Description :

The remote host is running a version of Microsoft Office which is subject 
to various flaws which may allow arbitrary code to be run.

An attacker may use this to execute arbitrary code on this host.

To succeed, the attacker would have to send a rogue file to 
a user of the remote computer and have it open it with
Microsoft Word or another Office application.

Solution : 

Microsoft has released a set of patches for Office for Mac OS X :

http://www.microsoft.com/technet/security/bulletin/ms07-014.mspx
http://www.microsoft.com/technet/security/bulletin/ms07-015.mspx

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for Word 2004";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


include("ssh_func.inc");
include("macosx_func.inc");


uname = get_kb_item("Host/uname");
if ( egrep(pattern:"Darwin.*", string:uname) )
{
  off2004 = GetCarbonVersionCmd(file:"Microsoft Word", path:"/Applications/Microsoft Office 2004");
  if ( ! islocalhost() )
  {
   soc = ssh_login_or_reuse_connection();
   if ( ! soc ) exit(0);
   buf = ssh_cmd(socket:soc, cmd:off2004);
  }
  else
  buf = pread(cmd:"bash", argv:make_list("bash", "-c", off2004));


 if ( buf =~ "^11\." )
	{
	  vers = split(buf, sep:'.', keep:FALSE);
          # < 11.3.4
	  if ( int(vers[0]) == 11 && ( int(vers[1]) < 3  || ( int(vers[1]) == 3 && int(vers[2]) < 4 ) ) ) security_hole(0);
	} 
}
