#TRUSTED 0d11441af9395e7b4b22c271d265a81fb040da8a3e3701bbe74512f72d784a3a24f432407a4733c72567ff9050223dc2b882f565bf0e941aea47b978688eb4773dd21d5f7e3bcbbb97e1d58295928e0bde443e1b722a17e77086c3a0254451bbce0c752e65c6be95d5fa0797e49e019abf0271774726f414176569b29a10038b7c7c9e5215846ebc3712cdf261af6af77af556d833eda3d2b24a6aef3234d7f3197b9953d7793b30298946f45e02087aa9204aff5ccab6b91ad1664705f2e93076f2a8214d6028f29d04c5723fe9de6a51f59454cd4fb8f11bb519a65ff7b98dbe98fb394789a5d20aaffb40479b3fef980d554797988c23ed248b011aeeeab85ac3593c2e055cc55dcb15c59c61d9487581e2893cc4216dd82db370a30f3c4caf60aa65c48d673e47fdaf873957b74d1e1bbae4018154bf15320da6093b8409422d5299c0b3fdd7950060fc0c1c46d8ab7ce7b448f551e1b009ba1808c0c3564368890ecf063e9669d1b6b60557a60a6fbcd0d721bfd6b41f392dc9fd1be0047dde5caf82e87b1ff3c6a1866d33dae73e87eb16376373d2bac608a220323dc7a99ae1ffdae23c2dd720ca7b2a42542e7049fa3370515895a512ab4a34ba482ec2464fda5bcdd537ed0f1677eed55618f24e578cb6b0a5670d781116f0b408e1fc18eaa2fc82e36e0d704449038b824062b7584a778ad9451a3205659039f1af
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25173);
 script_version ("1.0");
 script_bugtraq_id(23760, 23779, 23780, 23804, 23826, 23836);
 script_cve_id("CVE-2007-0215", "CVE-2007-1203", "CVE-2007-1214", "CVE-2007-0035", "CVE-2007-0870", "CVE-2007-1202", "CVE-2007-1747");
 script_xref(name:"OSVDB", value:"34387");
 script_xref(name:"OSVDB", value:"34388");
 script_xref(name:"OSVDB", value:"34394");
 script_xref(name:"OSVDB", value:"34395");
 script_xref(name:"OSVDB", value:"34396");
 
 name["english"] = "Vulnerabilities in Microsoft Office Allow Remote Code Execution (934233,934232,934873) (Mac OS X)";
 

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through Microsoft
Office.

Description :

The remote host is running a version of Microsoft Office
which is subject to various flaws which may allow arbitrary code to be run.

An attacker may use this to execute arbitrary code on this host.

To succeed, the attacker would have to send a rogue file to 
a user of the remote computer and have it open it with
Microsoft Word, Excel or another Office application.

Solution : 

Microsoft has released a set of patches for Office for Mac OS X :

http://www.microsoft.com/technet/security/Bulletin/MS07-023.mspx
http://www.microsoft.com/technet/security/Bulletin/MS07-024.mspx
http://www.microsoft.com/technet/security/Bulletin/MS07-025.mspx


Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for Office 2004 and X";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


include("ssh_func.inc");
include("macosx_func.inc");


uname = get_kb_item("Host/uname");
if ( egrep(pattern:"Darwin.*", string:uname) )
{
  off2004 = GetCarbonVersionCmd(file:"Microsoft Component Plugin", path:"/Applications/Microsoft Office 2004/Office");

  if ( ! islocalhost() )
  {
   soc = ssh_login_or_reuse_connection();
   if ( ! soc ) exit(0);
   buf = ssh_cmd(socket:soc, cmd:off2004);
   ssh_close_connection();
  }
  else
  buf = pread(cmd:"bash", argv:make_list("bash", "-c", off2004));


 if ( buf =~ "^11\." )
	{
	  vers = split(buf, sep:'.', keep:FALSE);
	  if ( (int(vers[0]) == 11 && int(vers[1]) < 3)  || 
               (int(vers[0]) == 11 && int(vers[1]) == 3 && int(vers[2]) < 5 ) ) security_hole(0);
	} 
}
