#TRUSTED 233c5ba14e5c5ee29573053433a72717e1f79cd47d571981014dad5d089b9a3c5e59c12918423643f093c5077d6179a056fc5796172dd2133511a38cd362e29b8333050cd7fd21c9e8f9681f18d76991d9a68913e0764babe2e7b0c78ec4de7c5dce1fd32f2ace6ceb9fd6fa194c525d141b58d1f2a1c6e391d3aa76c76b875c28167aa8a46818a3925b412be4d4dd1249188b233a53cff32e84ac6ba5ba117956e7daed9272deff89ed17bd9064c8e44ef9459c9529dadd395f307b49e681b0eefae6c9e0536cb11764399a83f28e4c246c05f68a9cddefdea9b85472c71c3e35710e38d0e066b54162458843889a5779a82643245e6538ba3368c510ba7f70b3c5c8a1233d626bc941f4f02859fcf350c57bf85af88b1b2b595cf93a2a688e11400ed100d3d82c5b1259a059f72fb60303c0b5e6578fe81901e4e8286bb3094a6b8af17fcbb34e8b10d4977fbabf699ff9655cd003b99fb036adbee187c203432a7675c7e6c77b580a117462ee8360e1a36173420e7b1bef70b1391e43f736f0fc637615b15dce8759165da113778e950fbfe35cdf98cae7bf69476b4b91a6e29a0e4923b98d4df53dd74ce8c27946a778f5bfd9060da63868f5af8feaf031a5503009878a5ca00e4d68907778d1251ee50b6f485d250225397f2a8753bb6a0a2f6673c004d9cfc8538bad275d80bcae0362cda50c33cb359291f5a8d615a3
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(22539);
 script_version ("1.0");
 if ( NASL_LEVEL >= 3000 ) 
   script_cve_id("CVE-2006-3435", 
		"CVE-2006-3876", 
		"CVE-2006-3877", 
		"CVE-2006-4694", 
		"CVE-2006-2387", 
		"CVE-2006-3431",
		"CVE-2006-3867",
		"CVE-2006-3875",
		"CVE-2006-3647",
		"CVE-2006-3651",
		"CVE-2006-4534",
		"CVE-2006-4693",
		"CVE-2006-3434",
		"CVE-2006-3650",
		"CVE-2006-3864",
		"CVE-2006-3868"
	);
 
 name["english"] = "Vulnerabilities in Microsoft Office Allow Remote Code Execution (924163,924164,924554,922581) (Mac OS X)";
 

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through Microsoft
Office.

Description :

The remote host is running a version of Microsoft Office
which is subject to various flaws which may allow arbitrary code to be run.

An attacker may use this to execute arbitrary code on this host.

To succeed, the attacker would have to send a rogue file to 
a user of the remote computer and have it open it with
Microsoft Word, Excel, PowerPoint or another Office application.

Solution : 

Microsoft has released a set of patches for Office for Mac OS X :

http://www.microsoft.com/technet/security/Bulletin/MS06-058.mspx
http://www.microsoft.com/technet/security/Bulletin/MS06-059.mspx
http://www.microsoft.com/technet/security/Bulletin/MS06-060.mspx
http://www.microsoft.com/technet/security/Bulletin/MS06-062.mspx


Risk factor : 

High / CVSS Base Score : 7.6
(CVSS2#AV:N/AC:H/Au:N/C:C/I:C/A:C)";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for Office 2004 and X";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


include("ssh_func.inc");
include("macosx_func.inc");


uname = get_kb_item("Host/uname");
if ( egrep(pattern:"Darwin.*", string:uname) )
{
  off2004 = GetCarbonVersionCmd(file:"Microsoft Component Plugin", path:"/Applications/Microsoft Office 2004/Office");
  offX    = GetCarbonVersionCmd(file:"Microsoft Component Plugin", path:"/Applications/Microsoft Office X/Office");

  if ( ! islocalhost() )
  {
   soc = ssh_login_or_reuse_connection();
   if ( ! soc ) exit(0);
   buf = ssh_cmd(socket:soc, cmd:off2004);
   if ( buf !~ "^11" )
    buf = ssh_cmd(socket:soc, cmd:offX);
   ssh_close_connection();
  }
  else
  {
  buf = pread(cmd:"bash", argv:make_list("bash", "-c", off2004));
  if ( buf !~ "^11" )
    buf = pread(cmd:"bash", argv:make_list("bash", "-c", offX));
  }


 if ( buf =~ "^(10\.|11\.)" )
	{
	  vers = split(buf, sep:'.', keep:FALSE);
	  # < 10.1.8
	  if ( int(vers[0]) == 10 && ( int(vers[1]) < 1  || ( int(vers[1]) == 1 && int(vers[2]) < 8 ) ) )  security_hole(0);
	  else
          # < 11.3.0
	  if ( int(vers[0]) == 11 && int(vers[1]) < 3  ) security_hole(0);
	} 
}
