#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24345);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-0651", "CVE-2007-0652");
  script_bugtraq_id(22554);
  script_xref(name:"OSVDB", value:"33188");
  script_xref(name:"OSVDB", value:"33189");
  script_xref(name:"OSVDB", value:"33190");
  script_xref(name:"OSVDB", value:"33191");

  script_name(english:"MailEnable Web Mail Client Multiple Vulnerabilities");
  script_summary(english:"Checks version of MailEnable");

  desc = "
Synopsis :

The remote webmail service is affected by multiple issues. 

Description :

The Web Mail Client bundled with the version of MailEnable installed
on the remote host reportedly fails to properly sanitize email
messages and various script parameters of malicious script code, which
can lead to cross-site scripting, cross-site request forgery, and
script insertion attacks against the affected software. 

See also :

http://secunia.com/secunia_research/2007-38/advisory/
http://www.mailenable.com/Professional20-ReleaseNotes.txt
http://www.mailenable.com/Enterprise20-ReleaseNotes.txt

Solution :

Upgrade to MailEnable Professional Edition 1.85 / 2.37 or Enterprise
1.42 / 2.37 or later as they are rumoured to address the issues. 

Risk factor :

Medium / CVSS Base Score : 5.1
(CVSS2#AV:N/AC:H/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("mailenable_detect.nasl");
  script_require_keys("SMB/MailEnable/Installed");
  script_require_ports(139, 445);

  exit(0);
}


if (!get_kb_item("SMB/MailEnable/Installed")) exit(0);
if (get_kb_item("SMB/MailEnable/Standard")) prod = "Standard";
if (get_kb_item("SMB/MailEnable/Professional")) prod = "Professional";
else if (get_kb_item("SMB/MailEnable/Enterprise")) prod = "Enterprise";


# Check version of MailEnable.
if (prod == "Professional" || prod == "Enterprise")
{
  kb_base = "SMB/MailEnable/" + prod;
  ver = get_kb_item(kb_base+"/Version");
  if (isnull(ver)) exit(0);

  if (
    # 1.0-1.84 Professional Edition
    # 2.0-2.36 Professional Edition
    (prod == "Professional" && ver =~ "^(1\.([0-7]($|[0-9.])|8$|8[0-4])|2\.([0-2]($|[0-9.])|3($|[0-6])))") ||
    # 1.0-1.41 Enterprise Edition
    # 2.0-2.36 Enterprise Edition
    (prod == "Enterprise" && ver =~ "^(1\.([0-3]($|[0-9].)|4$|4[01])|2\.([0-2]($|[0-9.])|3($|[0-6])))")
  ) security_warning(get_kb_item("SMB/transport"));
}
