#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2004:034
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24467);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2004:034: rpmdrake";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2004:034 (rpmdrake).

When rpmdrake would come across a package name containing the string
'-h' it would print out the help usage instead of installing or
upgrading a package.
The updated packages fix this. It is recommended that all users
upgrade immediately.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2004:034
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the rpmdrake package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"park-rpmdrake-2.1.3-2.4.100mdk", release:"MDK10.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"rpmdrake-2.1.3-2.4.100mdk", release:"MDK10.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
