#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2005:047
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24473);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2005:047: apcupsd";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2005:047 (apcupsd).

The apcupsd package as shipped with Mandriva Linux 2006 was missing the
main apcupsd configuration file. As a result, those upgrading from
earlier versions would have their existing configuration file moved to
/etc/apcupsd/apcupsd.conf.rpmsave with no new configuration file to
replace it, which would prevent the service from starting.
The new packages provide the configuration file. Users affected by
this will manually need to move back the .rpmsave configuration file,
however.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2005:047
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apcupsd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"apcupsd-3.10.18-3.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
