#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2005:052
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24478);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2005:052: ldetect-lst";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2005:052 (ldetect-lst).

The updated ldetect-lst packages provide five new PCI modem definitions
in the hardware database. This will prevent drakconnect from
misconfiguring these modems as a large number of Conexant and Smart Link
modems share the same PCI ids, thus requiring additional information in
the database.
This package also fixes a minor bug where the PCVC840K ToUcam Pro
webcam was wrongly displayed as a PCVC740K.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2005:052
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ldetect-lst package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"ldetect-lst-0.1.114-1.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ldetect-lst-devel-0.1.114-1.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
