#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2005:054
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24480);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2005:054: autofs";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2005:054 (autofs).

A problem with how autofs was linked with the LDAP libraries would
cause autofs to segfault on startup.
The updated package has been fixed to correct this problem.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2005:054
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the autofs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"autofs-4.1.4-4.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
