#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2005:057
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24483);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2005:057: drakxtools";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2005:057 (drakxtools).

A number of bugs have been fixed in this new drakxtools package,
primarily within the diskdrake, drakconnect and drakroam programs:
Diskdrake fixes include:
- handle 'users' the way 'user' is handled
- handle dmraid-1.0.0 RC9 (#19654)
Drakconnect fixes include:
- don't screw up eagle-usb devices if the firmware is already loaded
- fix zd1201 devices detection as well
Drakroam fixes include:
- remember 'restricted' wireless mode
- don't crash if mandi isn't started (#19608)
- fix wireless network list using iwlist (#19742)

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2005:057
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the drakxtools package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"drakx-finish-install-10.3-0.64.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"drakxtools-10.3-0.64.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"drakxtools-backend-10.3-0.64.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"drakxtools-http-10.3-0.64.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"drakxtools-newt-10.3-0.64.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"harddrake-10.3-0.64.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"harddrake-ui-10.3-0.64.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
