#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2005:059
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24485);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2005:059: digikam";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2005:059 (digikam).

The printing functionality of DigiKam in Mandriva 2006 is flawed in
that when trying to print a picture, regardless of the size, it swaps
near infinitely and takes an extremely long time until the photo comes
out. As well, the photo may not come out because GhostScript fails
due to lack of memory.
The updated packages have been patched to correct this problem.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2005:059
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the digikam package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"digikam-0.8.0-3.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kipi-plugins-0.1.0-0.rc1.2.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libdigikam0-0.8.0-3.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libdigikam0-devel-0.8.0-3.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
