#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2005:060
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24486);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2005:060: msec";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2005:060 (msec).

Bugs in the msec package have been corrected:
msec wasn't properly parsing the output on security checks to check
ownership of files, reporting files as unowned when they were in fact
properly owned by a valid user.
The /var/lib/msec/security.conf was no longer being generated which
prevented msec from running.
The updated packages have been patched to correct these problems.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2005:060
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the msec package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"msec-0.49.1-0.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
