#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2006:016
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24500);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2006:016: libgphoto";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2006:016 (libgphoto).

A bug was discovered with libgphoto which was preventing the removal
of icons on the desktop (in GNOME) or in the Devices window (in KDE)
when a digital camera was unplugged.
Updated packages have been patched to correct the issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2006:016
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libgphoto package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libgphoto2-2.1.6-8.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgphoto2-devel-2.1.6-8.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgphoto-hotplug-2.1.6-8.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
