#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2006:034
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24512);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2006:034: ipsec-tools";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2006:034 (ipsec-tools).

IPsec-Tools[1] is a port of KAME's IPsec utilities to the Linux-2.6 IPsec
implementation.
This update fixes a few issues and introduces new functionalities to the
package provided for Mandriva 2006 users:
- fixed tunnel mode connection (#19460 [2])
- fixed GSSAPI build
- version update: 0.6.6
- enabled PAM authentication support
- better default configuration files
- other fixes
It is recommended that users of ipsec-tools upgrade their packages. After the
upgrade, the services will be restarted automatically if needed.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2006:034
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ipsec-tools package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"ipsec-tools-0.6.6-1.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libipsec0-0.6.6-1.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libipsec0-devel-0.6.6-1.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
