#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2006:038
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24515);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2006:038: squid";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2006:038 (squid).

This update fixes a problem in the squid package as shipped for
Mandriva Linux 2007 which affects only the x86_64 architecture. On
that platform, squid would not start, giving the following message:
FATAL: Bungled Default Configuration line 44: hosts_file
This has been fixed in the updated packages. It is recommended that
all affected users upgrade squid.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2006:038
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the squid package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"squid-2.6.STABLE1-4.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"squid-cachemgr-2.6.STABLE1-4.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
