#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2006:041
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24517);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2006:041: smbldap-tools";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2006:041 (smbldap-tools).

This update fixes a problem with the smbldap-tools package shipped with
Mandriva Linux 2006 where it would issue warnings if the smb.conf
configuration file had continuation lines using the '' character.
The updated packages correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2006:041
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the smbldap-tools package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"smbldap-tools-0.9.1-2.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
