#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2006:044
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24519);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2006:044: xinetd";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2006:044 (xinetd).

The initscript for xinetd incorrectly set the locale to en_US. If the
locales-en package is not installed on the system, some xinetd services
may not work properly. This was first noted with the svnserve program
from subversion.
This has been fixed in the updated packages, which set the locale to a
generic value. Users not wishing to apply the update can work-around
the problem by installing the locales-en package.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2006:044
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xinetd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"xinetd-2.3.14-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xinetd-ipv6-2.3.14-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xinetd-simple-services-2.3.14-3.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
