#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2006:045
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24520);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2006:045: coreutils";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2006:045 (coreutils).

The coreutils package lacked several features due to a build
deficiency. As a result, the su program was not linked against the PAM
library, making it impossible for su to make use of advanced
authentication features that rely on the PAM library. As well, the cp
system utility did not keep extended attributes and ACLs in file
copies.
This has been corrected in the updated packages.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2006:045
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the coreutils package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"coreutils-5.97-5.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"coreutils-doc-5.97-5.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
