#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2006:046
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24521);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2006:046: bootsplash";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2006:046 (bootsplash).

When multiple profiles are configured, they can be choosen in the
bootloader with the PROFILE keyword, but this needs a dedicated entry
or to append manually the profile at each boot. To ease the choice of
the profile during the boot time, Mandriva developed a frame buffer
menu in GTK to choose the profile.
Unfortunately in 2007, a miscompilation removed this application from
the bootsplash package, thus the only left method to choose a profile
was the bootloader one. This new package of bootsplash brings back the
'fbmenu' command which display the appropriate profile selection menu
during boot.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2006:046
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bootsplash package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"bootsplash-3.1.14-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
