#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2006:056
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24531);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2006:056: drakxtools";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2006:056 (drakxtools).

Several bugs were fixed in drakxtools:
- it was not possible to start rpmdrake from the menu (#26383) - it was
not possible to set up updates media and then distro media (or the
reverse) in edit-urpm-sources - drakauth: o add encrypted home and
pam_mount support o hide password when calling 'net join' or 'net ads
join' (pixel) - drakbackup: o fix archiver detection/config file
replace (stew, #26705, #27180) o do not backup the backups (Adamw) -
drakboot: support Xen with lilo using mbootpack - drakfirewall: really
disable services (#27295) - drakvpn: o add pkcs11 token support for
openvpn o ask password/PIN if needed - drakconnect/drakroam: o detect
wireless interfaces with unknown driver, e.g. rt61 o do not check for
ipw3945 kernel module packages o do not wrongly tell that
acx100-firmware can be found in Club or commercial editions (#26475) o
use iwpriv commands to configure WPA on rt2570 and rt61 chipsets o
update madwifi URL which was old - finish-install: add encrypted home
and pam_mount support - printerdrake: due to changes in the format of
HPLIP's device description XML files, scanner functionality was not
recognized any more (#26567).

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2006:056
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the drakxtools package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"drakx-finish-install-10.4.81-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"drakxtools-10.4.81-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"drakxtools-backend-10.4.81-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"drakxtools-http-10.4.81-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"drakxtools-newt-10.4.81-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"harddrake-10.4.81-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"harddrake-ui-10.4.81-2.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
