#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2007:010
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24547);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2007:010: wvstreams";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2007:010 (wvstreams).

In Mandriva 2007.0, the wvstreams package was built with openssl 0.9.7,
which was not available in the final 2007.0 release. This made the
wvstreams package impossible to install on Mandriva 2007.0 (bug 26240).
This update is built with openssl 0.9.8, so that it can be installed on
a Mandriva 2007.0 system.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2007:010
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wvstreams package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libwvstreams3.74-3.74.0-7.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libwvstreams3.74-devel-3.74.0-7.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
