#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2007:018-1
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24803);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2007:018-1: timezone";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2007:018-1 (timezone).

Updated timezone packages are being provided for older Mandriva Linux
systems that do not contain the new Daylight Savings Time information
for 2007 for certain time zones. These updated packages contain the
new information.
Update:
This update addresses timezone files such as Canada/Mountain that had
not been previously updated to the DST information. While files such
as MST7MDT were updated, the counterpart files such as Canada/Mountain
or America/Edmonton, etc. were not. This update addresses that and
also ensures that the new timezone information is copied over
/etc/localtime so no further configuration is required.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2007:018-1
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the timezone package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"timezone-2007c-0.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"timezone-2007c-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
