#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2007:027
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25112);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2007:027: php-session";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2007:027 (php-session).

The php-session package includes a cron setting to remove PHP sessions
that are no longer in use. Previously, it could expire the session
even if it was still in use. This update will prevent the cron job
from removing sessions that are still actively being used, and will
only expire after the last action done in the session is older than
the number of minutes defined in /var/lib/php/maxlifetime.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2007:027
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the php-session package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"php-session-5.1.6-1.2mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
