#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2007:029-1
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25134);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2007:029-1: squidGuard";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2007:029-1 (squidGuard).

A problem with the upgrade scripts in the squidGuard package would
remove the contents of /usr/share/squidGuard-1.2.0 upon upgrade
instead of retaining them. This update corrects those scripts so
that directory is no longer removed.
Update:
Packages for other Mandriva Linux versions are now available.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2007:029-1
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the squidGuard package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"squidGuard-1.2.0-12.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"squidGuard-1.2.0-13.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
