#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2007:035
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25210);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2007:035: curl";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2007:035 (curl).

The curl shipped with 2007.0 had a bug which prevented it from working
with the Club repositories, meaning users could not access the Club
repositories unless they switched the default downloader for urpmi and
rpmdrake to be wget. This update fixes the bug and allows the Club
repositories to work with curl as the default downloader for urpmi
and rpmdrake, saving users the need to change the default downloader.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2007:035
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the curl package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"curl-7.15.5-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libcurl3-7.15.5-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libcurl3-devel-7.15.5-2.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
