#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2007:090
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26044);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "MDKA-2007:090: bind";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2007:090 (bind).

A number of bugs in the BIND9 packages are fixed in this update:
Threading was disabled in the ISC BIND package shipped with Mandriva
Linux 2007 and Corporate Server 4, because the host command did not
work properly with threading enabled. This update only builds the
host command without threading, while the rest of the bind server is
once again SMP-aware.
The bogon ACL was too restrictive and accidentally contained IP
address ranges for some root server networks.
The named daemon is chrooted by default, but logrotate files were
being supplied that served no purpose as named performs it's own
log rotating. The spurious logrotate files have been removed.
The updated packages correct these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2007:090
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bind package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"bind-9.3.2-8.4mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bind-devel-9.3.2-8.4mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bind-utils-9.3.2-8.4mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bind-9.4.1-0.3mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bind-devel-9.4.1-0.3mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bind-utils-9.4.1-0.3mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
