#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKA-2007:127
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29341);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "MDKA-2007:127: openssh-askpass-qt";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKA-2007:127 (openssh-askpass-qt).

The QT openssh password asking dialog, provided by openssh-askpass-qt
package, would always exit with successful status (0), even when
the user did not press the Ok button. This would, at least, make the
openssh client always allow sharing a connection when ControlMaster
option was set to ask.
This update fixes the issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKA-2007:127
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openssh-askpass-qt package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"openssh-askpass-qt-0.2-1.1mdv2007.0", release:"MDK2007.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-qt-0.2-1.1mdv2007.1", release:"MDK2007.1", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-qt-0.2-2.1mdv2008.0", release:"MDK2008.0", yank:"mdv") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
