#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2003:109
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14091);
 script_bugtraq_id(9115);
 script_version ("$Revision: 1.6 $");
 script_cve_id("CVE-2003-0971");
 
 name["english"] = "MDKSA-2003:109: gnupg";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2003:109 (gnupg).


A severe vulnerability was discovered in GnuPG by Phong Nguyen relating to
ElGamal sign+encrypt keys. From Werner Koch's email message:
'Phong Nguyen identified a severe bug in the way GnuPG creates and uses ElGamal
keys for signing. This is a significant security failure which can lead to a
compromise of almost all ElGamal keys used for signing. Note that this is a real
world vulnerability which will reveal your private key within a few seconds.
Please *take immediate action and revoke your ElGamal signing keys*. Furthermore
you should take whatever measures necessary to limit the damage done for signed
or encrypted documents using that key.'
And also:
'Note that the standard keys as generated by GnuPG (DSA and ElGamal encryption)
as well as RSA keys are NOT vulnerable. Note also that ElGamal signing keys
cannot be generated without the use of a special flag to enable hidden options
and even then overriding a warning message about this key type. See below for
details on how to identify vulnerable keys.'
MandrakeSoft urges any users who use the ElGamal sign+encrypt keys to
immediately revoke these keys and discontinue use of them. Updated packages are
provided that remove the ability to create these keys and to create signatures
using these keys (thanks to David Shaw for writing the patch).


Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2003:109
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnupg package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gnupg-1.0.7-3.2.90mdk", release:"MDK9.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gnupg-1.2.2-1.2.91mdk", release:"MDK9.1", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gnupg-1.2.3-3.1.92mdk", release:"MDK9.2", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"gnupg-", release:"MDK9.0")
 || rpm_exists(rpm:"gnupg-", release:"MDK9.1")
 || rpm_exists(rpm:"gnupg-", release:"MDK9.2") )
{
 set_kb_item(name:"CVE-2003-0971", value:TRUE);
}
