#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2004:125
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15636);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CVE-2004-0986");
 
 name["english"] = "MDKSA-2004:125: iptables";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2004:125 (iptables).



Faheem Mitha discovered that the iptables tool would not always load the
required modules on its own as it should have, which could in turn lead to
firewall rules not being loaded on system startup in some cases.

The updated packages are patched to prevent this problem.



Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2004:125
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the iptables package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"iptables-1.2.9-5.1.100mdk", release:"MDK10.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"iptables-ipv6-1.2.9-5.1.100mdk", release:"MDK10.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"iptables-1.2.9-7.1.101mdk", release:"MDK10.1", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"iptables-devel-1.2.9-7.1.101mdk", release:"MDK10.1", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"iptables-ipv6-1.2.9-7.1.101mdk", release:"MDK10.1", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"iptables-1.2.8-2.1.92mdk", release:"MDK9.2", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"iptables-ipv6-1.2.8-2.1.92mdk", release:"MDK9.2", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"iptables-", release:"MDK10.0")
 || rpm_exists(rpm:"iptables-", release:"MDK10.1")
 || rpm_exists(rpm:"iptables-", release:"MDK9.2") )
{
 set_kb_item(name:"CVE-2004-0986", value:TRUE);
}
