#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2005:087
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(18276);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CVE-2005-1278", "CVE-2005-1279", "CVE-2005-1280");
 
 name["english"] = "MDKSA-2005:087: tcpdump";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2005:087 (tcpdump).



A number of Denial of Service vulnerabilities were discovered in the way that
tcpdump processes certain network packets. If abused, these flaws can allow a
remote attacker to inject a carefully crafted packet onto the network, crashing
tcpdump.

The provided packages have been patched to correct these issues.



Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2005:087
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tcpdump package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"tcpdump-3.8.1-1.2.100mdk", release:"MDK10.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tcpdump-3.8.3-2.1.101mdk", release:"MDK10.1", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tcpdump-3.8.3-2.1.102mdk", release:"MDK10.2", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"tcpdump-", release:"MDK10.0")
 || rpm_exists(rpm:"tcpdump-", release:"MDK10.1")
 || rpm_exists(rpm:"tcpdump-", release:"MDK10.2") )
{
 set_kb_item(name:"CVE-2005-1278", value:TRUE);
 set_kb_item(name:"CVE-2005-1279", value:TRUE);
 set_kb_item(name:"CVE-2005-1280", value:TRUE);
}
