#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:126
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23877);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-3600");
 
 name["english"] = "MDKSA-2006:126: libtunepimp";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:126 (libtunepimp).

Kevin Kofler discovered multiple stack-based buffer overflows in the
LookupTRM::lookup function in libtunepimp 0.4.2 that allow remote
user-complicit attackers to cause a denial of service (application crash)
and possibly execute code via a long (1) Album release date
(MBE_ReleaseGetDate), (2) data, or (3) error strings.
Updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:126
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libtunepimp package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libtunepimp2-0.3.0-3.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libtunepimp2-devel-0.3.0-3.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libtunepimp2-static-devel-0.3.0-3.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libtunepimp2-utils-0.3.0-3.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libtunepimp-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-3600", value:TRUE);
}
