#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:132
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23882);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-3376");
 
 name["english"] = "MDKSA-2006:132: libwmf";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:132 (libwmf).

Integer overflow in player.c in libwmf 0.2.8.4, as used in multiple products
including (1) wv, (2) abiword, (3) freetype, (4) gimp, (5) libgsf, and
(6) imagemagick allows remote attackers to execute arbitrary code via the
MaxRecordSize header field in a WMF file.
Updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:132
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libwmf package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libwmf0.2_7-0.2.8.3-6.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libwmf0.2_7-devel-0.2.8.3-6.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libwmf-0.2.8.3-6.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"libwmf-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-3376", value:TRUE);
}
