#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:135
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23885);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-3913");
 
 name["english"] = "MDKSA-2006:135: freeciv";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:135 (freeciv).

Buffer overflow in Freeciv 2.1.0-beta1 and earlier, and SVN 15 Jul
2006 and earlier, allows remote attackers to cause a denial of service
(crash) and possibly execute arbitrary code via a (1) negative
chunk_length or a (2) large chunk->offset value in a
PACKET_PLAYER_ATTRIBUTE_CHUNK packet in the
generic_handle_player_attribute_chunk function in common/packets.c, and
(3) a large packet->length value in the handle_unit_orders function in
server/unithand.c.
The updated packages have been patched to fix this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:135
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the freeciv package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"freeciv-client-2.0.4-2.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freeciv-data-2.0.4-2.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freeciv-server-2.0.4-2.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"freeciv-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-3913", value:TRUE);
}
