#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:140
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23889);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-1168");
 
 name["english"] = "MDKSA-2006:140: ncompress";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:140 (ncompress).

Tavis Ormandy, of the Google Security Team, discovered that ncompress,
when uncompressing data, performed no bounds checking, which could
allow a specially crafted datastream to underflow a .bss buffer with
attacker controlled data.
Updated packages have been patched to correct this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:140
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ncompress package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"ncompress-4.2.4-28.1.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"ncompress-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-1168", value:TRUE);
}
