#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:161
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23905);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4339");
 
 name["english"] = "MDKSA-2006:161: openssl";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:161 (openssl).

Daniel Bleichenbacher recently described an attack on PKCS #1 v1.5
signatures where an RSA key with a small exponent used could be
vulnerable to forgery of a PKCS #1 v1.5 signature signed by that
key.
Any software using OpenSSL to verify X.509 certificates is potentially
vulnerable to this issue, as well as any other use of PKCS #1 v1.5,
including software uses OpenSSL for SSL or TLS.
Updated packages are patched to address this issue.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:161
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openssl package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libopenssl0.9.7-0.9.7g-2.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libopenssl0.9.7-devel-0.9.7g-2.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libopenssl0.9.7-static-devel-0.9.7g-2.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssl-0.9.7g-2.3.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"openssl-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-4339", value:TRUE);
}
