#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:162
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23906);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4481", "CVE-2006-4484", "CVE-2006-4485");
 
 name["english"] = "MDKSA-2006:162: php";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:162 (php).

The (1) file_exists and (2) imap_reopen functions in PHP before 5.1.5
do not check for the safe_mode and open_basedir settings, which allows
local users to bypass the settings (CVE-2006-4481).
Buffer overflow in the LWZReadByte function in ext/gd/libgd/gd_gif_in.c
in the GD extension in PHP before 5.1.5 allows remote attackers to have
an unknown impact via a GIF file with input_code_size greater than
MAX_LWZ_BITS, which triggers an overflow when initializing the table
array (CVE-2006-4484).
The stripos function in PHP before 5.1.5 has unknown impact and attack
vectors related to an out-of-bounds read (CVE-2006-4485).
CVE-2006-4485 does not affect the Corporate3 or MNF2 versions of PHP.
Updated packages have been patched to correct these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:162
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the php package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libphp5_common5-5.0.4-9.14.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-cgi-5.0.4-9.14.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-cli-5.0.4-9.14.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-devel-5.0.4-9.14.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-fcgi-5.0.4-9.14.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-imap-5.0.4-2.4.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"php-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-4481", value:TRUE);
 set_kb_item(name:"CVE-2006-4484", value:TRUE);
 set_kb_item(name:"CVE-2006-4485", value:TRUE);
}
