#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:165
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23909);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-2941", "CVE-2006-3636", "CVE-2006-4624");
 
 name["english"] = "MDKSA-2006:165: mailman";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:165 (mailman).

A flaw was discovered in how Mailman handles MIME multipart messages
where an attacker could send a carefully-crafted MIME multipart
message to a Mailman-run mailing list causing that mailing list to
stop working (CVE-2006-2941).
As well, a number of XSS (cross-site scripting) issues were discovered
that could be exploited to perform XSS attacks against the Mailman
administrator (CVE-2006-3636).
Finally, a CRLF injection vulnerability allows remote attackers to
spoof messages in the error log (CVE-2006-4624).
Updated packages have been patched to address these issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:165
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mailman package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mailman-2.1.6-6.4.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"mailman-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-2941", value:TRUE);
 set_kb_item(name:"CVE-2006-3636", value:TRUE);
 set_kb_item(name:"CVE-2006-4624", value:TRUE);
}
