#
# (C) Tenable Network Security
#
# This plugin text was extracted from Mandrake Linux Security Advisory MDKSA-2006:166
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24552);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4339", "CVE-2006-4790");
 
 name["english"] = "MDKSA-2006:166: gnutls";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory MDKSA-2006:166 (gnutls).

verify.c in GnuTLS before 1.4.4, when using an RSA key with exponent 3,
does not properly handle excess data in the digestAlgorithm.parameters
field when generating a hash, which allows remote attackers to forge a
PKCS #1 v1.5 signature that is signed by that RSA key and prevents
GnuTLS from correctly verifying X.509 and other certificates that use
PKCS, a variant of CVE-2006-4339.
The provided packages have been patched to correct this issues.

Solution : http://wwwnew.mandriva.com/security/advisories?name=MDKSA-2006:166
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnutls package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Mandrake/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gnutls-1.0.25-2.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgnutls11-1.0.25-2.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgnutls11-devel-1.0.25-2.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgnutls11-1.0.25-2.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgnutls11-devel-1.0.25-2.2.20060mdk", release:"MDK2006.0", yank:"mdk") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if (rpm_exists(rpm:"gnutls-", release:"MDK2006.0") )
{
 set_kb_item(name:"CVE-2006-4339", value:TRUE);
 set_kb_item(name:"CVE-2006-4790", value:TRUE);
}
